# SaaS OS v1.0 — Free Edition

This package is the Free Edition distribution of SaaS OS (V1).

It includes:
- Figma source link (view-only)
- Engineering contracts (Button + Input)
- Basic Cursor adapter
- Exported design tokens

This edition is designed for evaluation, learning, and building simple UI structures using a contract-driven approach.

---

## Authority (Free Edition)

Authoritative order:

1) Contract documents in `/docs/engineering/contracts`
2) Exported tokens in `/tokens-export`
3) Figma reference file (design layer)

If a conflict exists, contracts win.

---

## Folder Structure

- `/figma`  
  View-only Figma source for design reference.

- `/docs`  
  Documentation including:
  - Engineering contracts (Button + Input)
  - Quick reference guides
  - Usage boundaries

- `/tokens-export`  
  Token exports for implementation:
  - `tokens.css` (CSS variables)
  - `tokens.json` (structured token map)
  - `tokens.ts` (typed token bindings)

- `/adapters/cursor`  
  Basic AI/Cursor usage pack:
  - `system-rules.md`
  - `prompt-pack-basic.md`
  - Example prompts

---

## Usage

1) Import `/tokens-export/tokens.css` globally in your project.
2) Implement UI components strictly according to `/docs/engineering/contracts`.
3) When using Cursor:
   - Load `/adapters/cursor/system-rules.md`
   - Reference the relevant contract explicitly
   - Keep prompts narrow and component-focused

---

## Scope (Free Edition)

This edition includes foundational tokens and core contracts.

Advanced components, flows, architectural enforcement, and extended prompt systems
are available in SaaS OS Pro.

---

## Principle

Contracts define meaning.
Code must conform to contracts.